rollout DYNsunLight ""
(
  ---SECTION 1 - SET UP LOCAL VARIABLES---
  local LOCobj

  ---SECTION 2 - DEFINE LOCAL FUNCTIONS---
  fn DYNFUNskyParams FUNsky =
  (
    DYNsunLight.LOCobj        = FUNsky

    if superClassOf FUNsky == Light then DYNsunLight.LBDYNlightName.text = FUNsky.name

    if classOf FUNsky == IES_Sky or classOf FUNsky == Skylight then
    (
      DYNsunLight.LOCobj                    = FUNsky
      DYNsunLight.CKDYNskyOn.checked        = FUNsky.on
      DYNsunLight.SPDYNskyMult.value        = FUNsky.multiplier

      if classOf FUNsky == Skylight then
      (
        DYNsunLight.LBDYNlightName.text      += (" (" + DYNuiResourcesLabels[137] + ")")
        DYNsunLight.GBDYNgroup01.text         = DYNuiResourcesGroups[39]
        DYNsunLight.RBDYNskyCover.visible     = false
        DYNsunLight.LBDYNskyCover.visible     = false
        DYNsunLight.RBDYNskyMode.visible      = true
        DYNsunLight.CKDYNcolorMapOn.visible   = true
        DYNsunLight.SPDYNcolorMapAmt.visible  = true
        DYNsunLight.MBDYNskyColorMap.visible  = true
        DYNsunLight.CODYNcolor.pos.y          = 109

        DYNsunLight.RBDYNskyMode.state        = FUNsky.sky_mode + 1
        DYNsunLight.CKDYNcolorMapOn.enabled   = (FUNsky.sky_mode == 1); DYNsunLight.CKDYNcolorMapOn.checked   = FUNsky.sky_color_map_on
        DYNsunLight.CODYNcolor.enabled        = (FUNsky.sky_mode == 1); DYNsunLight.CODYNcolor.color          = FUNsky.color
        DYNsunLight.SPDYNcolorMapAmt.enabled  = (FUNsky.sky_mode == 1); DYNsunLight.SPDYNcolorMapAmt.value    = FUNsky.sky_color_map_amt

        DYNsunLight.MBDYNskyColorMap.enabled  = (FUNsky.sky_mode == 1)
        if SuperClassOf FUNsky.sky_color_map == textureMap then
        (
          local LOCname = filterString ((FUNsky.sky_color_map) as string) ":"
          DYNsunLight.MBDYNskyColorMap.text = LOCname[1] + "  ( " + LOCname[2] + " )"
        )
        else (DYNsunLight.MBDYNskyColorMap.text = DYNuiResourcesButtons[49])
      )
      else
      (
        DYNsunLight.LBDYNlightName.text      += (" (" + DYNuiResourcesLabels[138] + ")")
        DYNsunLight.GBDYNgroup01.text         = DYNuiResourcesGroups[40]
        DYNsunLight.RBDYNskyCover.visible     = true
        DYNsunLight.LBDYNskyCover.visible     = true
        DYNsunLight.RBDYNskyMode.visible      = false
        DYNsunLight.CKDYNcolorMapOn.visible   = false
        DYNsunLight.SPDYNcolorMapAmt.visible  = false
        DYNsunLight.MBDYNskyColorMap.visible  = false
        DYNsunLight.CODYNcolor.pos.y          = 74

        if FUNsky.sky_cover < 0.25 then DYNsunLight.RBDYNskyCover.state = 1
        if FUNsky.sky_cover > 0.25 and FUNsky.sky_cover < 0.75 then DYNsunLight.RBDYNskyCover.state = 2
        if FUNsky.sky_cover > 0.75 then DYNsunLight.RBDYNskyCover.state = 3

        DYNsunLight.CKDYNcolorMapOn.enabled   = false
        DYNsunLight.CODYNcolor.enabled        = true; DYNsunLight.CODYNcolor.color          = FUNsky.color
        DYNsunLight.SPDYNcolorMapAmt.enabled  = false
        DYNsunLight.MBDYNskyColorMap.enabled  = false
      )

      DYNsunLight.CKDYNskyCast.checked      = FUNsky.baseObject.castShadows
      DYNsunLight.SPDYNraysPerSamp.value    = FUNsky.rays_per_sample
      DYNsunLight.SPDYNskyRayBias.value     = FUNsky.ray_bias
      DYNsunLight.CKDYNskyCast.enabled      = (classOf sceneRadiosity.radiosity != Light_Tracer)
      DYNsunLight.SPDYNraysPerSamp.enabled  = (classOf sceneRadiosity.radiosity != Light_Tracer)
      DYNsunLight.SPDYNskyRayBias.enabled   = (classOf sceneRadiosity.radiosity != Light_Tracer)
      DYNsunLight.LBDYNraysPerSamp.enabled  = (classOf sceneRadiosity.radiosity != Light_Tracer)
      DYNsunLight.LBDYNskyRayBias.enabled   = (classOf sceneRadiosity.radiosity != Light_Tracer)
    )
    else
    (
      for i in DYNsunLight.controls do i.enabled = false
    )
  )

  ---SECTION 3 - DEFINE PANEL LAYOUT---
  label LBDYNlightName align:#center
  groupbox GBDYNgroup01 pos:[4,24] width:(DYNiniExplorerWidth - 21) height:156

  checkbox CKDYNskyOn align:#left pos:[13,45] width:50
  label  LBDYNskyMult width:75 pos:[65,46]
  spinner  SPDYNskyMult "" fieldwidth:60 range:[0.0,1000000000.0,1.0] type:#float pos:[(DYNiniExplorerWidth - 96),46] scale:0.01

  label LBDYNskyColor        align:#left   pos:[13,74]
  label LBDYNskyCover        align:#left   pos:[13,106]
  radiobuttons RBDYNskyCover align:#left   pos:[13,125] labels:#(DYNuiResourcesLabels[126], DYNuiResourcesLabels[127], DYNuiResourcesLabels[128]) columns:1
  radiobuttons RBDYNskyMode  align:#left   pos:[13,92]  labels:#(DYNuiResourcesLabels[129], DYNuiResourcesLabels[130]) columns:1
  colorpicker CODYNcolor     align:#left   pos:[(DYNiniExplorerWidth - 98),109] height:15 width:72
  checkbox CKDYNcolorMapOn   align:#left   pos:[13,129]
  spinner SPDYNcolorMapAmt   align:#right  pos:[(DYNiniExplorerWidth - 96),129] range:[0.0,100.0,0.0] type:#float fieldwidth:60
  mapbutton MBDYNskyColorMap "" align:#center pos:[13,150] width:(DYNiniExplorerWidth - 38)

  groupbox GBDYNgroup02 pos:[4,185] width:(DYNiniExplorerWidth - 21) height:85
  checkbox CKDYNskyCast      align:#left   pos:[13,204]
  label   LBDYNraysPerSamp   align:#left   pos:[13,226] width:100
  spinner SPDYNraysPerSamp   align:#left   pos:[(DYNiniExplorerWidth - 96),224] range:[1,64,1] type:#integer fieldwidth:60
  label   LBDYNskyRayBias    align:#left   pos:[13,246] width:100
  spinner SPDYNskyRayBias    align:#left   pos:[(DYNiniExplorerWidth - 96),244] range:[0.0,1000000000.0,1.0] type:#float fieldwidth:60 scale:0.01

  on DYNsunLight open do
  (
    DYNsunLight.title     = DYNuiRolloutNames[11]
    GBDYNgroup02.text     = DYNuiResourcesGroups[38]
    LBDYNskyMult.text     = DYNuiResourcesLabels[131]
    CKDYNskyCast.text     = DYNuiResourcesLabels[20]
    CKDYNcolorMapOn.text  = DYNuiResourcesLabels[132]
    LBDYNskyRayBias.text  = DYNuiResourcesLabels[133]
    LBDYNraysPerSamp.text = DYNuiResourcesLabels[134]
    LBDYNskyColor.text    = DYNuiResourcesLabels[135]
    LBDYNskyCover.text    = DYNuiResourcesLabels[136]

    CKDYNskyOn.text       = DYNuiResourcesLabels[22]
  )

  on CKDYNskyOn changed arg do
  (
    LOCobj.on = arg
    if DYNLightList.open then
    (
      DYNlightList.DYNFUNupdateLightInstances LOCobj
    )
  )

  on SPDYNskyMult changed arg do LOCobj.multiplier = arg
  on SPDYNskyMult entered do
  (
    if DYNLightList.open then
    (
      DYNlightList.DYNFUNupdateLightInstances LOCobj

      local LOCitem = DYNFUNfindListViewItemByTag DYNlightList.dnLights (LOCobj.inode.handle as string)
      if LOCitem != undefined then LOCitem.SubItems.item[1].text = SPDYNskyMult.value as string
    )
  )

  on RBDYNskyMode changed arg do
  (
    LOCobj.sky_mode = arg - 1
    DYNsunLight.CODYNcolor.enabled       = (arg == 2)
    DYNsunLight.CKDYNcolorMapOn.enabled  = (arg == 2)
    DYNsunLight.SPDYNcolorMapAmt.enabled = (arg == 2)
    DYNsunLight.MBDYNskyColorMap.enabled = (arg == 2)
  )

  on RBDYNskyCover changed arg do
  (
    if arg == 1 then LOCobj.sky_cover = 0.0
    if arg == 2 then LOCobj.sky_cover = 0.5
    if arg == 3 then LOCobj.sky_cover = 1.0
  )

  on CODYNcolor changed arg do
  (
    LOCobj.color = arg
  )

  on CKDYNcolorMapOn changed arg do
  (
    LOCobj.sky_color_map_on = arg
  )

  on SPDYNcolorMapAmt changed arg do
  (
    LOCobj.sky_color_map_amt = arg
  )

  on MBDYNskyColorMap picked arg do
  (
    LOCobj.sky_color_map = arg
    if SuperClassOf LOCobj.sky_color_map == textureMap then
    (
      local LOCname = filterString ((LOCobj.sky_color_map) as string) ":"
      DYNsunLight.MBDYNskyColorMap.text = LOCname[1] + "  ( " + LOCname[2] + " )"
    )
    else
    (
      DYNsunLight.MBDYNskyColorMap.text = DYNuiResourcesButtons[49]
    )
  )

  on CKDYNskyCast changed arg do
  (
    LOCobj.baseObject.castShadows = arg
    if DYNLightList.open then
    (
      DYNlightList.DYNFUNupdateLightInstances LOCobj

      local LOCitem = DYNFUNfindListViewItemByTag DYNlightList.dnLights (LOCobj.inode.handle as string)
      if LOCitem != undefined then LOCitem.SubItems.item[2].text = arg as string
    )
  )

  on SPDYNraysPerSamp changed arg do
  (
    LOCobj.rays_per_sample = arg
  )

  on SPDYNskyRayBias changed arg do
  (
    LOCobj.ray_bias = arg
  )
)
